

#ifdef MACVERSION
#include <standard.h>
#endif

#ifdef WIN95VERSION
#include "standard.h"
#endif

#include "bitmaps.h"
#include "icon.h"
#include "memory.h"
#include "quickdraw.h"
#include "sounds.h"
#include "strings.h"
#include "shell.rsrc.h"
#include "langexternal.h"
#include "tableinternal.h"


/*
static char *iconstrings [] = {
	
	"\pZoom",			/*0%/
	
	"\pOutline", 		/*1%/
	
	"\pWP-Text", 		/*2%/
	
	nil,
	
	"\pTable", 			/*4%/
	
	"\pScript", 		/*5%/
	
	"\pMenuBar", 		/*6%/
	
	"\pPicture" 		/*7%/
	};
*/


boolean tablecursoriszoomable (void) {
	
	hdlhashtable htable;
	bigstring bsname;
	tyvaluerecord val;
	hdlhashnode hnode;
	
	if (!tablegetcursorinfo (&htable, bsname, &val, &hnode))
		return (false);
	
	return ((val.valuetype == externalvaluetype) || (val.valuetype == novaluetype));
	} /*tablecursoriszoomable*/


boolean tablecheckzoombutton (void) {
	
	/*
	2.1b6 dmb: changed checking logic. we get called by callers who need the 
	flag to be right, instead of when it might change. return true of it did 
	change.
	*/
	
	register hdltableformats hf = tableformatsdata;
	register boolean flenabled;
	
	flenabled = tablecursoriszoomable ();
	
	if ((**hf).fliconenabled != flenabled) {
		
		(**hf).fliconenabled = flenabled;
		
		return (true);
		}
	
	return (false);
	
	/*
	register short ixicontitle;
	bigstring bs;
	tyvaluerecord val;
	
	ixicontitle = 0; /*default%/
	
	if (tablegetcursorinfo (bs, &val)) {
		
		if (val.valuetype == externalvaluetype)
			ixicontitle = langexternalgettype (val) + 1;
		}
	
	if ((**hi).ixicontitle != ixicontitle) {
		
		(**hi).ixicontitle = ixicontitle;
		
		(**hi).fliconenabled = flenabled;
		
		invalrect ((**hi).iconrect);
		}
	*/
	} /*tablecheckzoombutton*/


void tabledrawzoombutton (boolean flpressed) {
	
	hdltableformats hf = tableformatsdata;
	Rect r = (**hf).iconrect;
	bigstring bs;
	boolean flbitmap;
	
	tablecheckzoombutton (); /*check now instead of when it changes*/
	
	/*
	copystring (iconstrings [info.ixicontitle], bs);
	*/
	
	if (!isemptyrect (r)) {
			
		shellgetstring (zoombuttonstring, bs);
		
		flbitmap = openbitmap (r, tableformatswindow);
		
		eraserect (r);
		
		drawlabeledwindoidicon (r, bs, (**hf).flactive && (**hf).fliconenabled, flpressed);
		
		if (flbitmap)
			closebitmap (tableformatswindow);
		}
	} /*tabledrawzoombutton*/


boolean tablezoombuttonhit (void) {
	
	register hdltableformats hf = tableformatsdata;
	
	if (!trackicon ((**hf).iconrect, &tabledrawzoombutton))  /*user changed its mind*/
		return (true);
	
	return (tabledive ());
	} /*tablezoombuttonhit*/


boolean tablecursorisrunnable (void) {
	
	/*
	returns true if the value pointed to by the table cursor can be run.
	*/
	
	register boolean flrunnable;
	hdlhashtable  htable;
	bigstring bs;
	tyvaluerecord val;
	hdlhashnode hnode;
	
	if (!tablegetcursorinfo (&htable, bs, &val, &hnode)) 
		return (false);
		
	flrunnable = false;
	
	switch (val.valuetype) {
		
		case stringvaluetype:
			flrunnable = true;
			
			break;
			
		case externalvaluetype:
			switch (langexternalgettype (val)) {
				
				case idscriptprocessor:
					flrunnable = true;
					
					break;
				} /*switch*/
				
			break;
		} /*switch*/
		
	return (flrunnable);
	} /*tablecursorisrunnable*/


boolean tableruncursor (void) {
	
	register hdltableformats hf = tableformatsdata;
	tyvaluerecord val;
	hdlhashtable htable;
	bigstring bs;
	bigstring bsscript, bsresult;
	Handle htext;
	hdlhashnode hnode;
	
	if (!tableexiteditmode ())
		return (false);
	
	if (!tablegetcursorinfo (&htable, bs, &val, &hnode)) {
		
		ouch ();
		
		return (false);
		}
	
	switch (val.valuetype) {
		
		case stringvaluetype: {
			if (!copyhandle (val.data.stringvalue, &htext))
				return (false);
			
			return (langrunhandle (htext, bsresult)); /*consumes htext*/
			}
		
		case externalvaluetype:
			switch (langexternalgettype (val)) {
				
				case idscriptprocessor:
					tablegetcursorpath (bsscript);
					
					pushstring ((ptrstring) "\x02()", bsscript);
					
					return (langrunstring (bsscript, bsresult));
				} /*switch*/
				
			break;
		} /*switch*/
	
	ouch ();
	
	return (false);
	} /*tableruncursor*/




